/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class DatatablesColumns {
    private final Map<Integer, InternalColumn> columns = new TreeMap<Integer, InternalColumn>();

    public Iterable<Column> getColumns() {
        ArrayList<Column> values = new ArrayList<Column>(this.columns.size());
        values.addAll(this.columns.values());
        return values;
    }

    public void setData(int index, String data) {
        this.getColumn(index).setData(data);
    }

    public void setName(int index, String name) {
        this.getColumn(index).setName(name);
    }

    public void setSearchable(int index, boolean searchable) {
        this.getColumn(index).setSearchable(searchable);
    }

    public void setOrderable(int index, boolean orderable) {
        this.getColumn(index).setOrderable(orderable);
    }

    public void setSearchRegexp(int index, boolean regexp) {
        this.getColumn(index).setSearchRegex(regexp);
    }

    public void setSearch(int index, String search) {
        this.getColumn(index).setSearch(search);
    }

    public String toString() {
        return "DatatablesColumns [columns=" + this.columns + "]";
    }

    private InternalColumn getColumn(int index) {
        InternalColumn column = this.columns.get(index);
        if (column == null) {
            column = new InternalColumn(index);
            this.columns.put(index, column);
        }
        return column;
    }

    private static class InternalColumn
    implements Column {
        private final int index;
        private String data;
        private String name;
        private boolean searchable;
        private boolean orderable;
        private boolean searchRegex;
        private String search;

        public InternalColumn(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean isSearchable() {
            return this.searchable;
        }

        public void setSearchable(boolean searchable) {
            this.searchable = searchable;
        }

        @Override
        public boolean isOrderable() {
            return this.orderable;
        }

        public void setOrderable(boolean orderable) {
            this.orderable = orderable;
        }

        @Override
        public boolean isSearchRegex() {
            return this.searchRegex;
        }

        public void setSearchRegex(boolean searchRegex) {
            this.searchRegex = searchRegex;
        }

        @Override
        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public String toString() {
            return "InternalColumn [index=" + this.index + ", data=" + this.data + ", name=" + this.name + ", searchable=" + this.searchable + ", orderable=" + this.orderable + ", searchRegex=" + this.searchRegex + ", search=" + this.search + "]";
        }
    }

    public static interface Column {
        public int getIndex();

        public String getData();

        public String getName();

        public boolean isSearchable();

        public boolean isOrderable();

        public boolean isSearchRegex();

        public String getSearch();
    }
}

