/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Datatables {
    public static final String MEDIA_TYPE = "application/vnd.datatables+json";
    public static final String PARAMETER_DRAW = "draw";
    public static final String PARAMETER_LENGTH = "length";
    public static final String PARAMETER_START = "start";
    private static final String PARAM_COLUMN_PREFIX = "columns[";
    private static final String PARAM_COLUMN_NAME_SUFIX = "][data]";
    private static final String PARAM_ORDER_DIR_SUFIX = "][dir]";
    private static final String PARAM_ORDER_PREFIX = "order[";
    private static final String PARAM_ORDER_COLUMN_SUFIX = "][column]";
    private static final String PARAM_SEARCH_TYPE = "search";
    private static final Pattern COLUMN_INDEX_PATTERN = Pattern.compile("columns\\[([0-9]*)?\\]*");
    private static final Pattern COLUMN_TYPE_PATTERN = Pattern.compile("columns\\[([0-9]*)?\\]\\[([a-z]*)?\\]*");

    public static String orderColumnIndexParameter(int index) {
        return PARAM_ORDER_PREFIX + index + PARAM_ORDER_COLUMN_SUFIX;
    }

    public static String orderDirectionParameter(int index) {
        return PARAM_ORDER_PREFIX + index + PARAM_ORDER_DIR_SUFIX;
    }

    public static String columnNameParameter(String columnPosition) {
        return PARAM_COLUMN_PREFIX + columnPosition + PARAM_COLUMN_NAME_SUFIX;
    }

    public static boolean isColumn(String parameter) {
        return parameter != null && parameter.startsWith(PARAM_COLUMN_PREFIX);
    }

    public static int columnIndex(String parameter) {
        if (Datatables.isColumn(parameter)) {
            Matcher matcher = COLUMN_INDEX_PATTERN.matcher(parameter);
            while (matcher.find()) {
                try {
                    return Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return -1;
    }

    public static ColumnParamType columnParameterType(String parameter) {
        if (Datatables.isColumn(parameter)) {
            Matcher matcher = COLUMN_TYPE_PATTERN.matcher(parameter);
            while (matcher.find()) {
                String type = matcher.group(2);
                if (PARAM_SEARCH_TYPE.equals(type) && parameter.endsWith("[search][regex]")) {
                    return ColumnParamType.REGEX;
                }
                try {
                    return ColumnParamType.valueOf(type.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    public static enum ColumnParamType {
        DATA,
        NAME,
        SEARCHABLE,
        ORDERABLE,
        SEARCH,
        REGEX;

    }
}

