/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.service.Header;

public class ResponseHeaders {
    private ResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public static Map<String, Header> headers(ResponseHeader[] responseHeaders) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        Stream.of(responseHeaders).filter(ResponseHeaders.emptyOrVoid().negate()).forEachOrdered(each -> headers.put(each.name(), new Header(each.name(), each.description(), ResponseHeaders.headerModel(each))));
        return headers;
    }

    private static Predicate<ResponseHeader> emptyOrVoid() {
        return input -> StringUtils.isEmpty((Object)input.name()) || Void.class.equals((Object)input.response());
    }

    private static ModelReference headerModel(ResponseHeader each) {
        String typeName = Optional.ofNullable(Types.typeNameFor((Type)each.response())).orElse("string");
        ModelRef modelReference = StringUtils.isEmpty((Object)each.responseContainer()) ? new ModelRef(typeName) : new ModelRef(each.responseContainer(), (ModelReference)new ModelRef(typeName));
        return modelReference;
    }
}

