/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import springfox.documentation.service.Documentation;

public class DocumentationCache {
    private Map<String, Documentation> documentationLookup = new LinkedHashMap<String, Documentation>();

    public void addDocumentation(Documentation documentation) {
        this.documentationLookup.put(documentation.getGroupName(), documentation);
    }

    public Documentation documentationByGroup(String groupName) {
        return this.documentationLookup.get(groupName);
    }

    public Map<String, Documentation> all() {
        return Collections.unmodifiableMap(this.documentationLookup);
    }

    public void clear() {
        this.documentationLookup.clear();
    }
}

