/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.util.UriUtils;

public class ControllerNamingUtils {
    private static Logger log = LoggerFactory.getLogger(ControllerNamingUtils.class);
    private static final String ISO_8859_1 = "ISO-8859-1";

    public static String pathRoot(String requestPattern) {
        Assert.notNull((Object)requestPattern);
        Assert.hasText((String)requestPattern);
        log.info("Resolving path root for {}", (Object)requestPattern);
        requestPattern = requestPattern.startsWith("/") ? requestPattern : "/" + requestPattern;
        int idx = requestPattern.indexOf("/", 1);
        if (idx > -1) {
            return requestPattern.substring(0, idx);
        }
        return requestPattern;
    }

    public static String pathRootEncoded(String requestPattern) {
        return ControllerNamingUtils.encode(ControllerNamingUtils.pathRoot(requestPattern));
    }

    public static String encode(String path) {
        try {
            path = UriUtils.encodePath((String)path, (String)ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not encode:" + path, (Throwable)e);
        }
        return path;
    }

    public static String decode(String path) {
        try {
            path = UriUtils.decode((String)path, (String)ISO_8859_1);
        }
        catch (Exception e) {
            log.error("Could not decode:" + path, (Throwable)e);
        }
        return path;
    }
}

