/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

class EntityDeleteExtractor
implements EntityOperationsExtractor {
    EntityDeleteExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        CrudMethods crudMethods = context.crudMethods();
        TypeResolver resolver = context.getTypeResolver();
        RepositoryMetadata repository = context.getRepositoryMetadata();
        if (crudMethods.hasDelete()) {
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), crudMethods.getDeleteMethod());
            ActionSpecification spec = new ActionSpecification(RequestExtractionUtils.actionName(entity, crudMethods.getDeleteMethod()), String.format("%s%s/{id}", context.basePath(), context.resourcePath()), Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.DELETE}), new HashSet<MediaType>(), new HashSet<MediaType>(), handler, Lists.newArrayList((Object[])new ResolvedMethodParameter[]{new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id", handler), resolver.resolve((Type)repository.getIdType(), new Type[0]))}), resolver.resolve(Void.TYPE, new Type[0]));
            handlers.add(new SpringDataRestRequestHandler(context, spec));
        }
        return handlers;
    }
}

