/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.stereotype.Component;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.data.rest.DefaultExtractorConfiguration;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestHandlerExtractorConfiguration;
import springfox.documentation.spring.web.paths.Paths;

@Component
class EntityServicesProvider
implements RequestHandlerProvider {
    private final RepositoryRestConfiguration configuration;
    private final ResourceMappings mappings;
    private final Repositories repositories;
    private final TypeResolver typeResolver;
    private final PersistentEntities entities;
    private final Associations associations;
    private final RequestHandlerExtractorConfiguration extractorConfiguration;
    private final String contextPath;

    @Autowired
    EntityServicesProvider(ServletContext servletContext, RepositoryRestConfiguration configuration, ResourceMappings mappings, Repositories repositories, TypeResolver typeResolver, PersistentEntities entities, Associations associations, Optional<RequestHandlerExtractorConfiguration> extractorConfiguration) {
        this.mappings = mappings;
        this.configuration = configuration;
        this.repositories = repositories;
        this.typeResolver = typeResolver;
        this.entities = entities;
        this.associations = associations;
        this.extractorConfiguration = extractorConfiguration.orElse(new DefaultExtractorConfiguration());
        this.contextPath = Paths.contextPath((ServletContext)servletContext);
    }

    public List<RequestHandler> requestHandlers() {
        ArrayList contexts = new ArrayList();
        for (Class each : this.repositories) {
            this.repositories.getRepositoryInformationFor(each).ifPresent(repositoryInfo -> this.repositories.getRepositoryFor(each).ifPresent(repositoryInstance -> {
                ResourceMetadata resource = this.mappings.getMetadataFor(each);
                if (resource.isExported()) {
                    contexts.add(new EntityContext(this.typeResolver, this.contextPath, this.configuration, (RepositoryInformation)repositoryInfo, repositoryInstance, resource, this.mappings, this.entities, this.associations, this.extractorConfiguration));
                }
            }));
        }
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        for (EntityContext each : contexts) {
            handlers.addAll(this.extractorConfiguration.getEntityExtractors().stream().map(this.extractFromContext(each)).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return handlers;
    }

    private Function<EntityOperationsExtractor, List<RequestHandler>> extractFromContext(EntityContext context) {
        return input -> input.extract(context);
    }
}

