/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.google.common.base.Optional;
import com.google.common.collect.Ordering;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;

public class ApiDescriptionBuilder {
    private String path;
    private String description;
    private List<Operation> operations;
    private Ordering<Operation> operationOrdering;
    private Boolean hidden;
    private Optional<String> pathMapping;

    public ApiDescriptionBuilder(Ordering<Operation> operationOrdering) {
        this.operationOrdering = operationOrdering;
    }

    public ApiDescriptionBuilder path(String path) {
        this.path = BuilderDefaults.defaultIfAbsent(path, this.path);
        return this;
    }

    public ApiDescriptionBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ApiDescriptionBuilder operations(List<Operation> operations) {
        if (operations != null) {
            this.operations = this.operationOrdering.sortedCopy(operations);
        }
        return this;
    }

    public ApiDescriptionBuilder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ApiDescription build() {
        return new ApiDescription(this.path, this.description, this.operations, this.hidden);
    }
}

