/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.google.common.base.Optional;
import javax.validation.constraints.Pattern;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.BeanValidators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class PatternAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public void apply(ModelPropertyContext context) {
        Optional<Pattern> pattern = this.extractPattern(context);
        context.getBuilder().pattern(this.createPatternValueFromAnnotation(pattern));
    }

    Optional<Pattern> extractPattern(ModelPropertyContext context) {
        return BeanValidators.validatorFromBean(context, Pattern.class).or(BeanValidators.validatorFromField(context, Pattern.class));
    }

    private String createPatternValueFromAnnotation(Optional<Pattern> pattern) {
        String patternValue = null;
        if (pattern.isPresent()) {
            patternValue = ((Pattern)pattern.get()).regexp();
        }
        return patternValue;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

