/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483148)
public class NotBlankAnnotationPlugin
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(NotBlankAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        Optional<NotBlank> notBlank = Validators.annotationFromParameter(context, NotBlank.class);
        if (notBlank.isPresent()) {
            LOG.debug("@NotBlank present: setting parameter as required and not allowing empty values");
            context.parameterBuilder().required(true);
        }
    }
}

