/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/roles"})
public class RoleController {
    @Autowired
    private NacosRoleServiceImpl roleService;

    @GetMapping(params={"search=accurate"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public Object getRoles(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username, @RequestParam(name="role", defaultValue="") String role) {
        return this.roleService.getRolesFromDatabase(username, role, pageNo, pageSize);
    }

    @GetMapping(params={"search=blur"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public Page<RoleInfo> fuzzySearchRole(@RequestParam int pageNo, @RequestParam int pageSize, @RequestParam(name="username", defaultValue="") String username, @RequestParam(name="role", defaultValue="") String role) {
        return this.roleService.findRolesLike4Page(username, role, pageNo, pageSize);
    }

    @GetMapping(value={"/search"})
    @Secured(resource="console/roles", action=ActionTypes.READ)
    public List<String> searchRoles(@RequestParam String role) {
        return this.roleService.findRolesLikeRoleName(role);
    }

    @PostMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Object addRole(@RequestParam String role, @RequestParam String username) {
        this.roleService.addRole(role, username);
        return RestResultUtils.success((Object)"add role ok!");
    }

    @DeleteMapping
    @Secured(resource="console/roles", action=ActionTypes.WRITE)
    public Object deleteRole(@RequestParam String role, @RequestParam(name="username", defaultValue="") String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            this.roleService.deleteRole(role);
        } else {
            this.roleService.deleteRole(role, username);
        }
        return RestResultUtils.success((Object)("delete role of user " + username + " ok!"));
    }
}

