/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedPermissionPersistServiceImpl
implements PermissionPersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions WHERE ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions WHERE ";
        String where = " role= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)role)) {
            params = Collections.singletonList(role);
        } else {
            where = " 1=1 ";
        }
        Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.PERMISSION_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        String sql = "INSERT INTO permissions (role, resource, action) VALUES (?, ?, ?)";
        EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, resource, action});
        this.databaseOperate.blockUpdate();
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        String sql = "DELETE FROM permissions WHERE role=? AND resource=? AND action=?";
        EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, resource, action});
        this.databaseOperate.blockUpdate();
    }
}

