/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.control;

import com.alibaba.nacos.core.remote.control.MonitorType;
import com.alibaba.nacos.core.remote.control.TpsMonitorPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TpsRecorder {
    private long startTime;
    TimeUnit period;
    private int slotSize;
    private List<TpsSlot> slotList;
    private long maxCount = -1L;
    private String model;
    private String monitorType;

    public TpsRecorder(long startTime, TimeUnit period, String model, int recordSize) {
        this.monitorType = MonitorType.MONITOR.type;
        this.startTime = startTime;
        if (period.equals((Object)TimeUnit.MINUTES)) {
            this.startTime = TpsMonitorPoint.getTrimMillsOfMinute(startTime);
        }
        if (period.equals((Object)TimeUnit.HOURS)) {
            this.startTime = TpsMonitorPoint.getTrimMillsOfHour(startTime);
        }
        this.period = period;
        this.model = model;
        this.slotSize = recordSize + 1;
        this.slotList = new ArrayList<TpsSlot>(this.slotSize);
        for (int i = 0; i < this.slotSize; ++i) {
            this.slotList.add(this.isProtoModel() ? new MultiKeyTpsSlot() : new TpsSlot());
        }
    }

    public boolean isProtoModel() {
        return "PROTO".equalsIgnoreCase(this.model);
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public TpsSlot createSlotIfAbsent(long timeStamp) {
        long distance = timeStamp - this.startTime;
        long diff = (distance < 0L ? distance + this.period.toMillis(1L) * (long)this.slotSize : distance) / this.period.toMillis(1L);
        long currentWindowTime = this.startTime + diff * this.period.toMillis(1L);
        int index = (int)diff % this.slotSize;
        if (this.slotList.get((int)index).time != currentWindowTime) {
            this.slotList.get(index).reset(currentWindowTime);
        }
        return this.slotList.get(index);
    }

    public TpsSlot getPoint(long timeStamp) {
        long distance = timeStamp - this.startTime;
        long diff = (distance < 0L ? distance + this.period.toMillis(1L) * (long)this.slotSize : distance) / this.period.toMillis(1L);
        long currentWindowTime = this.startTime + diff * this.period.toMillis(1L);
        int index = (int)diff % this.slotSize;
        TpsSlot tpsSlot = this.slotList.get(index);
        if (tpsSlot.time != currentWindowTime) {
            return null;
        }
        return tpsSlot;
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(long maxCount) {
        this.maxCount = maxCount;
    }

    public boolean isInterceptMode() {
        return MonitorType.INTERCEPT.type.equals(this.monitorType);
    }

    public void clearLimitRule() {
        this.setMonitorType(MonitorType.MONITOR.type);
        this.setMaxCount(-1L);
    }

    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public List<TpsSlot> getSlotList() {
        return this.slotList;
    }

    static class SlotCountHolder {
        AtomicLong count = new AtomicLong();
        AtomicLong interceptedCount = new AtomicLong();

        SlotCountHolder() {
        }

        public String toString() {
            return "{" + this.count + "|" + this.interceptedCount + '}';
        }
    }

    static class MultiKeyTpsSlot
    extends TpsSlot {
        Map<String, SlotCountHolder> keySlots = new HashMap<String, SlotCountHolder>(16);

        MultiKeyTpsSlot() {
        }

        @Override
        public SlotCountHolder getCountHolder(String key) {
            if (!this.keySlots.containsKey(key)) {
                this.keySlots.putIfAbsent(key, new SlotCountHolder());
            }
            return this.keySlots.get(key);
        }

        public Map<String, SlotCountHolder> getKeySlots() {
            return this.keySlots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(long second) {
            MultiKeyTpsSlot multiKeyTpsSlot = this;
            synchronized (multiKeyTpsSlot) {
                if (this.time != second) {
                    this.time = second;
                    this.keySlots.clear();
                }
            }
        }

        @Override
        public String toString() {
            return "MultiKeyTpsSlot{time=" + this.time + "}'";
        }
    }

    static class TpsSlot {
        long time = 0L;
        private SlotCountHolder countHolder = new SlotCountHolder();

        TpsSlot() {
        }

        public SlotCountHolder getCountHolder(String key) {
            return this.countHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(long second) {
            TpsSlot tpsSlot = this;
            synchronized (tpsSlot) {
                if (this.time != second) {
                    this.time = second;
                    this.countHolder.count.set(0L);
                    this.countHolder.interceptedCount.set(0L);
                }
            }
        }

        public String toString() {
            return "TpsSlot{time=" + this.time + ", countHolder=" + this.countHolder + '}';
        }
    }
}

