/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.execute;

import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.component.DistroCallback;
import com.alibaba.nacos.core.distributed.distro.component.DistroComponentHolder;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.task.execute.AbstractDistroExecuteTask;
import com.alibaba.nacos.core.utils.Loggers;

public class DistroSyncChangeTask
extends AbstractDistroExecuteTask {
    private static final DataOperation OPERATION = DataOperation.CHANGE;

    public DistroSyncChangeTask(DistroKey distroKey, DistroComponentHolder distroComponentHolder) {
        super(distroKey, distroComponentHolder);
    }

    @Override
    protected DataOperation getDataOperation() {
        return OPERATION;
    }

    @Override
    protected boolean doExecute() {
        String type = this.getDistroKey().getResourceType();
        DistroData distroData = this.getDistroData(type);
        if (null == distroData) {
            Loggers.DISTRO.warn("[DISTRO] {} with null data to sync, skip", (Object)this.toString());
            return true;
        }
        return this.getDistroComponentHolder().findTransportAgent(type).syncData(distroData, this.getDistroKey().getTargetServer());
    }

    @Override
    protected void doExecuteWithCallback(DistroCallback callback) {
        String type = this.getDistroKey().getResourceType();
        DistroData distroData = this.getDistroData(type);
        if (null == distroData) {
            Loggers.DISTRO.warn("[DISTRO] {} with null data to sync, skip", (Object)this.toString());
            return;
        }
        this.getDistroComponentHolder().findTransportAgent(type).syncData(distroData, this.getDistroKey().getTargetServer(), callback);
    }

    public String toString() {
        return "DistroSyncChangeTask for " + this.getDistroKey().toString();
    }

    private DistroData getDistroData(String type) {
        DistroData result = this.getDistroComponentHolder().findDataStorage(type).getDistroData(this.getDistroKey());
        if (null != result) {
            result.setType(OPERATION);
        }
        return result;
    }
}

