/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.controller.v2;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.NodeState;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.model.request.LookupUpdateRequest;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/core/cluster"})
public class NacosClusterV2Controller {
    private final ServerMemberManager memberManager;

    public NacosClusterV2Controller(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @GetMapping(value={"/nodes/self"})
    public RestResult<Member> self() {
        return RestResultUtils.success((Object)this.memberManager.getSelf());
    }

    @GetMapping(value={"/nodes"})
    public RestResult<Collection<Member>> listNodes(@RequestParam(value="address", required=false) String address, @RequestParam(value="state", required=false) String state) {
        NodeState nodeState = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{state})) {
            try {
                nodeState = NodeState.valueOf(state.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return RestResultUtils.failedWithMsg((int)400, (String)("Illegal state: " + state));
            }
        }
        Collection<Member> members = this.memberManager.allMembers();
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{address}) && !StringUtils.startsWith((CharSequence)member.getAddress(), (CharSequence)address) || nodeState != null && member.getState() != nodeState) continue;
            result.add(member);
        }
        return RestResultUtils.success(result);
    }

    @PutMapping(value={"/nodes"})
    public RestResult<Void> updateNodes(@RequestBody List<Member> nodes) {
        for (Member node : nodes) {
            if (!node.check()) {
                LoggerUtils.printIfWarnEnabled((Logger)Loggers.CLUSTER, (String)"node information is illegal, ignore node: {}", (Object[])new Object[]{node});
                continue;
            }
            LoggerUtils.printIfDebugEnabled((Logger)Loggers.CLUSTER, (String)"node state updating, node: {}", (Object[])new Object[]{node});
            node.setState(NodeState.UP);
            node.setFailAccessCnt(0);
            boolean update = this.memberManager.update(node);
            if (update) continue;
            LoggerUtils.printIfErrorEnabled((Logger)Loggers.CLUSTER, (String)"node state update failed, node: {}", (Object[])new Object[]{node});
        }
        return RestResultUtils.success();
    }

    @PutMapping(value={"/lookup"})
    public RestResult<Void> updateLookup(@RequestBody LookupUpdateRequest request) {
        try {
            this.memberManager.switchLookup(request.getType());
            return RestResultUtils.success();
        }
        catch (Throwable ex) {
            return RestResultUtils.failed((String)ex.getMessage());
        }
    }

    @DeleteMapping(value={"/nodes"})
    public RestResult<Void> deleteNodes(@RequestParam(value="addresses") List<String> addresses) throws Exception {
        return RestResultUtils.failed((int)405, null, (String)"DELETE /v2/core/cluster/nodes API not allow to use temporarily.");
    }
}

