/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.config;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.PropertiesUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class AuthConfigs
extends Subscriber<ServerConfigChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthConfigs.class);
    private static final String PREFIX = "nacos.core.auth.plugin";
    @JustForTest
    private static Boolean cachingEnabled = null;
    @Value(value="${nacos.core.auth.enabled:false}")
    private boolean authEnabled;
    @Value(value="${nacos.core.auth.system.type:}")
    private String nacosAuthSystemType;
    @Value(value="${nacos.core.auth.server.identity.key:}")
    private String serverIdentityKey;
    @Value(value="${nacos.core.auth.server.identity.value:}")
    private String serverIdentityValue;
    @Value(value="${nacos.core.auth.enable.userAgentAuthWhite:false}")
    private boolean enableUserAgentAuthWhite;
    private Map<String, Properties> authPluginProperties = new HashMap<String, Properties>();

    public AuthConfigs() {
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.refreshPluginProperties();
    }

    private void refreshPluginProperties() {
        try {
            HashMap<String, Properties> newProperties = new HashMap<String, Properties>(1);
            Properties properties = PropertiesUtil.getPropertiesWithPrefix((Environment)EnvUtil.getEnvironment(), (String)PREFIX);
            for (String each : properties.stringPropertyNames()) {
                int typeIndex = each.indexOf(46);
                String type = each.substring(0, typeIndex);
                String subKey = each.substring(typeIndex + 1);
                newProperties.computeIfAbsent(type, key -> new Properties()).setProperty(subKey, properties.getProperty(each));
            }
            this.authPluginProperties = newProperties;
        }
        catch (Exception e) {
            LOGGER.warn("Refresh plugin properties failed ", (Throwable)e);
        }
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    public boolean isEnableUserAgentAuthWhite() {
        return this.enableUserAgentAuthWhite;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public boolean isCachingEnabled() {
        if (Objects.nonNull(cachingEnabled)) {
            return cachingEnabled;
        }
        return ConvertUtils.toBoolean((String)EnvUtil.getProperty((String)"nacos.core.auth.caching.enabled", (String)"true"));
    }

    public Properties getAuthPluginProperties(String authType) {
        if (!this.authPluginProperties.containsKey(authType)) {
            LOGGER.warn("Can't find properties for type {}, will use empty properties", (Object)authType);
            return new Properties();
        }
        return this.authPluginProperties.get(authType);
    }

    @JustForTest
    public static void setCachingEnabled(boolean cachingEnabled) {
        AuthConfigs.cachingEnabled = cachingEnabled;
    }

    public void onEvent(ServerConfigChangeEvent event) {
        try {
            this.authEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.enabled", Boolean.class, (Object)false);
            cachingEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.caching.enabled", Boolean.class, (Object)true);
            this.serverIdentityKey = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.key", (String)"");
            this.serverIdentityValue = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.value", (String)"");
            this.enableUserAgentAuthWhite = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.enable.userAgentAuthWhite", Boolean.class, (Object)false);
            this.nacosAuthSystemType = EnvUtil.getProperty((String)"nacos.core.auth.system.type", (String)"");
            this.refreshPluginProperties();
        }
        catch (Exception e) {
            LOGGER.warn("Upgrade auth config from env failed, use old value", (Throwable)e);
        }
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }
}

