/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth;

import com.alibaba.nacos.auth.ProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.auth.util.Loggers;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginManager;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import java.util.Optional;

public abstract class AbstractProtocolAuthService<R>
implements ProtocolAuthService<R> {
    protected final AuthConfigs authConfigs;

    protected AbstractProtocolAuthService(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
    }

    @Override
    public boolean enableAuth(Secured secured) {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).enableAuth(secured.action(), secured.signType());
        }
        Loggers.AUTH.warn("Can't find auth plugin for type {}, please add plugin to classpath or set {} as false", (Object)this.authConfigs.getNacosAuthSystemType(), (Object)"nacos.core.auth.enabled");
        return false;
    }

    @Override
    public boolean validateIdentity(IdentityContext identityContext, Resource resource) throws AccessException {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).validateIdentity(identityContext, resource);
        }
        return true;
    }

    @Override
    public boolean validateAuthority(IdentityContext identityContext, Permission permission) throws AccessException {
        Optional authPluginService = AuthPluginManager.getInstance().findAuthServiceSpiImpl(this.authConfigs.getNacosAuthSystemType());
        if (authPluginService.isPresent()) {
            return ((AuthPluginService)authPluginService.get()).validateAuthority(identityContext, permission);
        }
        return true;
    }

    protected Resource parseSpecifiedResource(Secured secured) {
        return new Resource(null, null, secured.resource(), "specified", null);
    }

    protected Resource useSpecifiedParserToParse(Secured secured, R request) {
        try {
            return secured.parser().newInstance().parse(request, secured);
        }
        catch (Exception e) {
            Loggers.AUTH.error("Use specified resource parser {} parse resource failed.", (Object)secured.parser().getCanonicalName(), (Object)e);
            return Resource.EMPTY_RESOURCE;
        }
    }
}

