/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.postgresml;

import java.util.Map;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.postgresml.PostgresMlEmbeddingClient;
import org.springframework.ai.postgresml.PostgresMlEmbeddingOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.postgresml.embedding")
public class PostgresMlEmbeddingProperties {
    public static final String CONFIG_PREFIX = "spring.ai.postgresml.embedding";
    private boolean enabled = true;
    @NestedConfigurationProperty
    private PostgresMlEmbeddingOptions options = PostgresMlEmbeddingOptions.builder().withTransformer("distilbert-base-uncased").withVectorType(PostgresMlEmbeddingClient.VectorType.PG_ARRAY).withKwargs(Map.of()).withMetadataMode(MetadataMode.EMBED).build();

    public PostgresMlEmbeddingOptions getOptions() {
        return this.options;
    }

    public void setOptions(PostgresMlEmbeddingOptions options) {
        Assert.notNull((Object)options, (String)"options must not be null.");
        Assert.notNull((Object)options.getTransformer(), (String)"transformer must not be null.");
        Assert.notNull((Object)options.getVectorType(), (String)"vectorType must not be null.");
        Assert.notNull((Object)options.getKwargs(), (String)"kwargs must not be null.");
        Assert.notNull((Object)options.getMetadataMode(), (String)"metadataMode must not be null.");
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

