/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter.converter;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class PgVectorFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    @Override
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        this.convertOperand(expression.right(), context);
    }

    private String getOperationSymbol(Filter.Expression exp) {
        switch (exp.type()) {
            case AND: {
                return " && ";
            }
            case OR: {
                return " || ";
            }
            case EQ: {
                return " == ";
            }
            case NE: {
                return " != ";
            }
            case LT: {
                return " < ";
            }
            case LTE: {
                return " <= ";
            }
            case GT: {
                return " > ";
            }
            case GTE: {
                return " >= ";
            }
            case IN: {
                return " in ";
            }
            case NIN: {
                return " nin ";
            }
        }
        throw new RuntimeException("Not supported expression type: " + String.valueOf((Object)exp.type()));
    }

    @Override
    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("$." + key.key());
    }

    @Override
    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    @Override
    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

