/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.util.Assert;

public class FilterHelper {
    private static final Map<Filter.ExpressionType, Filter.ExpressionType> TYPE_NEGATION_MAP = Map.of(Filter.ExpressionType.AND, Filter.ExpressionType.OR, Filter.ExpressionType.OR, Filter.ExpressionType.AND, Filter.ExpressionType.EQ, Filter.ExpressionType.NE, Filter.ExpressionType.NE, Filter.ExpressionType.EQ, Filter.ExpressionType.GT, Filter.ExpressionType.LTE, Filter.ExpressionType.GTE, Filter.ExpressionType.LT, Filter.ExpressionType.LT, Filter.ExpressionType.GTE, Filter.ExpressionType.LTE, Filter.ExpressionType.GT, Filter.ExpressionType.IN, Filter.ExpressionType.NIN, Filter.ExpressionType.NIN, Filter.ExpressionType.IN);

    private FilterHelper() {
    }

    public static Filter.Operand negate(Filter.Operand operand) {
        if (operand instanceof Filter.Group) {
            Filter.Group group = (Filter.Group)operand;
            Filter.Operand inEx = FilterHelper.negate(group.content());
            if (inEx instanceof Filter.Group) {
                Filter.Group inEx2 = (Filter.Group)inEx;
                inEx = inEx2.content();
            }
            return new Filter.Group((Filter.Expression)inEx);
        }
        if (operand instanceof Filter.Expression) {
            Filter.Expression exp = (Filter.Expression)operand;
            switch (exp.type()) {
                case NOT: {
                    return FilterHelper.negate(exp.left());
                }
                case AND: 
                case OR: {
                    return new Filter.Expression(TYPE_NEGATION_MAP.get((Object)exp.type()), FilterHelper.negate(exp.left()), FilterHelper.negate(exp.right()));
                }
                case EQ: 
                case NE: 
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    return new Filter.Expression(TYPE_NEGATION_MAP.get((Object)exp.type()), exp.left(), exp.right());
                }
                case IN: 
                case NIN: {
                    return new Filter.Expression(TYPE_NEGATION_MAP.get((Object)exp.type()), exp.left(), exp.right());
                }
            }
            throw new IllegalArgumentException("Unknown expression type: " + String.valueOf((Object)exp.type()));
        }
        throw new IllegalArgumentException("Can not negate operand of type: " + String.valueOf(operand.getClass()));
    }

    public static void expandIn(Filter.Expression exp, StringBuilder context, FilterExpressionConverter filterExpressionConverter) {
        Assert.isTrue((exp.type() == Filter.ExpressionType.IN ? 1 : 0) != 0, (String)("Expected IN expressions but was: " + String.valueOf((Object)exp.type())));
        FilterHelper.expandInNinExpressions(Filter.ExpressionType.OR, Filter.ExpressionType.EQ, exp, context, filterExpressionConverter);
    }

    public static void expandNin(Filter.Expression exp, StringBuilder context, FilterExpressionConverter filterExpressionConverter) {
        Assert.isTrue((exp.type() == Filter.ExpressionType.NIN ? 1 : 0) != 0, (String)("Expected NIN expressions but was: " + String.valueOf((Object)exp.type())));
        FilterHelper.expandInNinExpressions(Filter.ExpressionType.AND, Filter.ExpressionType.NE, exp, context, filterExpressionConverter);
    }

    private static void expandInNinExpressions(Filter.ExpressionType outerExpressionType, Filter.ExpressionType innerExpressionType, Filter.Expression exp, StringBuilder context, FilterExpressionConverter expressionConverter) {
        Filter.Operand operand = exp.right();
        if (operand instanceof Filter.Value) {
            Filter.Value value = (Filter.Value)operand;
            Object object = value.value();
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Filter.Expression> eqExprs = new ArrayList<Filter.Expression>();
                for (Object o : list) {
                    eqExprs.add(new Filter.Expression(innerExpressionType, exp.left(), new Filter.Value(o)));
                }
                context.append(expressionConverter.convertExpression(FilterHelper.aggregate(outerExpressionType, eqExprs)));
            } else {
                context.append(expressionConverter.convertExpression(new Filter.Expression(innerExpressionType, exp.left(), exp.right())));
            }
        } else {
            throw new IllegalStateException("Filter IN right expression should be of Filter.Value type but was " + String.valueOf(exp.right().getClass()));
        }
    }

    private static Filter.Expression aggregate(Filter.ExpressionType aggregateType, List<Filter.Expression> expressions) {
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return new Filter.Expression(aggregateType, expressions.get(0), FilterHelper.aggregate(aggregateType, expressions.subList(1, expressions.size())));
    }
}

