/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import java.util.Objects;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionTextParser;
import org.springframework.util.Assert;

public class SearchRequest {
    public static final double SIMILARITY_THRESHOLD_ACCEPT_ALL = 0.0;
    public static final int DEFAULT_TOP_K = 4;
    public String query;
    private int topK = 4;
    private double similarityThreshold = 0.0;
    private Filter.Expression filterExpression;

    private SearchRequest(String query) {
        this.query = query;
    }

    public static SearchRequest query(String query) {
        Assert.notNull((Object)query, (String)"Query can not be null.");
        return new SearchRequest(query);
    }

    public static SearchRequest defaults() {
        return new SearchRequest("");
    }

    public static SearchRequest from(SearchRequest originalSearchRequest) {
        return new SearchRequest(originalSearchRequest.getQuery()).withTopK(originalSearchRequest.getTopK()).withSimilarityThreshold(originalSearchRequest.getSimilarityThreshold()).withFilterExpression(originalSearchRequest.getFilterExpression());
    }

    public SearchRequest withQuery(String query) {
        Assert.notNull((Object)query, (String)"Query can not be null.");
        this.query = query;
        return this;
    }

    public SearchRequest withTopK(int topK) {
        Assert.isTrue((topK >= 0 ? 1 : 0) != 0, (String)"TopK should be positive.");
        this.topK = topK;
        return this;
    }

    public SearchRequest withSimilarityThreshold(double threshold) {
        Assert.isTrue((threshold >= 0.0 && threshold <= 1.0 ? 1 : 0) != 0, (String)"Similarity threshold must be in [0,1] range.");
        this.similarityThreshold = threshold;
        return this;
    }

    public SearchRequest withSimilarityThresholdAll() {
        return this.withSimilarityThreshold(0.0);
    }

    public SearchRequest withFilterExpression(Filter.Expression expression) {
        this.filterExpression = expression;
        return this;
    }

    public SearchRequest withFilterExpression(String textExpression) {
        this.filterExpression = textExpression != null ? new FilterExpressionTextParser().parse(textExpression) : null;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public int getTopK() {
        return this.topK;
    }

    public double getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public Filter.Expression getFilterExpression() {
        return this.filterExpression;
    }

    public boolean hasFilterExpression() {
        return this.filterExpression != null;
    }

    public String toString() {
        return "SearchRequest{query='" + this.query + "', topK=" + this.topK + ", similarityThreshold=" + this.similarityThreshold + ", filterExpression=" + String.valueOf(this.filterExpression) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRequest that = (SearchRequest)o;
        return this.topK == that.topK && Double.compare(that.similarityThreshold, this.similarityThreshold) == 0 && Objects.equals(this.query, that.query) && Objects.equals(this.filterExpression, that.filterExpression);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.topK, this.similarityThreshold, this.filterExpression);
    }
}

