/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.transformer.splitter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.ContentFormatter;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;

public abstract class TextSplitter
implements DocumentTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TextSplitter.class);
    private boolean copyContentFormatter = true;

    @Override
    public List<Document> apply(List<Document> documents) {
        return this.doSplitDocuments(documents);
    }

    public void setCopyContentFormatter(boolean copyContentFormatter) {
        this.copyContentFormatter = copyContentFormatter;
    }

    public boolean isCopyContentFormatter() {
        return this.copyContentFormatter;
    }

    private List<Document> doSplitDocuments(List<Document> documents) {
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<Map<String, Object>> metadataList = new ArrayList<Map<String, Object>>();
        ArrayList<ContentFormatter> formatters = new ArrayList<ContentFormatter>();
        for (Document doc : documents) {
            texts.add(doc.getContent());
            metadataList.add(doc.getMetadata());
            formatters.add(doc.getContentFormatter());
        }
        return this.createDocuments(texts, formatters, metadataList);
    }

    private List<Document> createDocuments(List<String> texts, List<ContentFormatter> formatters, List<Map<String, Object>> metadataList) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < texts.size(); ++i) {
            String text = texts.get(i);
            Map<String, Object> metadata = metadataList.get(i);
            List<String> chunks = this.splitText(text);
            if (chunks.size() > 1) {
                logger.info("Splitting up document into " + chunks.size() + " chunks.");
            }
            for (String chunk : chunks) {
                Map<String, Object> metadataCopy = metadata.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
                Document newDoc = new Document(chunk, metadataCopy);
                if (this.copyContentFormatter) {
                    newDoc.setContentFormatter(formatters.get(i));
                }
                documents.add(newDoc);
            }
        }
        return documents;
    }

    protected abstract List<String> splitText(String var1);
}

