/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.ChatClient;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;
import org.springframework.ai.document.MetadataMode;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SummaryMetadataEnricher
implements DocumentTransformer {
    private static final String SECTION_SUMMARY_METADATA_KEY = "section_summary";
    private static final String NEXT_SECTION_SUMMARY_METADATA_KEY = "next_section_summary";
    private static final String PREV_SECTION_SUMMARY_METADATA_KEY = "prev_section_summary";
    private static final String CONTEXT_STR_PLACEHOLDER = "context_str";
    public static final String DEFAULT_SUMMARY_EXTRACT_TEMPLATE = "Here is the content of the section:\n{context_str}\n\nSummarize the key topics and entities of the section.\n\nSummary:";
    private final ChatClient chatClient;
    private final List<SummaryType> summaryTypes;
    private final MetadataMode metadataMode;
    private final String summaryTemplate;

    public SummaryMetadataEnricher(ChatClient chatClient, List<SummaryType> summaryTypes) {
        this(chatClient, summaryTypes, DEFAULT_SUMMARY_EXTRACT_TEMPLATE, MetadataMode.ALL);
    }

    public SummaryMetadataEnricher(ChatClient chatClient, List<SummaryType> summaryTypes, String summaryTemplate, MetadataMode metadataMode) {
        Assert.notNull((Object)chatClient, (String)"ChatClient must not be null");
        Assert.hasText((String)summaryTemplate, (String)"Summary template must not be empty");
        this.chatClient = chatClient;
        this.summaryTypes = CollectionUtils.isEmpty(summaryTypes) ? List.of(SummaryType.CURRENT) : summaryTypes;
        this.metadataMode = metadataMode;
        this.summaryTemplate = summaryTemplate;
    }

    @Override
    public List<Document> apply(List<Document> documents) {
        ArrayList<String> documentSummaries = new ArrayList<String>();
        for (Document document : documents) {
            String documentContext = document.getFormattedContent(this.metadataMode);
            Prompt prompt = new PromptTemplate(this.summaryTemplate).create(Map.of(CONTEXT_STR_PLACEHOLDER, documentContext));
            documentSummaries.add(this.chatClient.call(prompt).getResult().getOutput().getContent());
        }
        for (int i = 0; i < documentSummaries.size(); ++i) {
            HashMap summaryMetadata = new HashMap();
            if (i > 0 && this.summaryTypes.contains((Object)SummaryType.PREVIOUS)) {
                summaryMetadata.put(PREV_SECTION_SUMMARY_METADATA_KEY, documentSummaries.get(i - 1));
            }
            if (i < documentSummaries.size() - 1 && this.summaryTypes.contains((Object)SummaryType.NEXT)) {
                summaryMetadata.put(NEXT_SECTION_SUMMARY_METADATA_KEY, documentSummaries.get(i + 1));
            }
            if (this.summaryTypes.contains((Object)SummaryType.CURRENT)) {
                summaryMetadata.put(SECTION_SUMMARY_METADATA_KEY, documentSummaries.get(i));
            }
            documents.get(i).getMetadata().putAll(summaryMetadata);
        }
        return documents;
    }

    public static enum SummaryType {
        PREVIOUS,
        CURRENT,
        NEXT;

    }
}

