/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.transformer;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.document.ContentFormatter;
import org.springframework.ai.document.DefaultContentFormatter;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;

public class ContentFormatTransformer
implements DocumentTransformer {
    private boolean disableTemplateRewrite = false;
    private ContentFormatter contentFormatter;

    public ContentFormatTransformer(ContentFormatter contentFormatter) {
        this(contentFormatter, false);
    }

    public ContentFormatTransformer(ContentFormatter contentFormatter, boolean disableTemplateRewrite) {
        this.contentFormatter = contentFormatter;
        this.disableTemplateRewrite = disableTemplateRewrite;
    }

    @Override
    public List<Document> apply(List<Document> documents) {
        if (this.contentFormatter != null) {
            documents.forEach(document -> {
                if (document.getContentFormatter() instanceof DefaultContentFormatter && this.contentFormatter instanceof DefaultContentFormatter) {
                    DefaultContentFormatter docFormatter = (DefaultContentFormatter)document.getContentFormatter();
                    DefaultContentFormatter toUpdateFormatter = (DefaultContentFormatter)this.contentFormatter;
                    ArrayList<String> updatedEmbedExcludeKeys = new ArrayList<String>(docFormatter.getExcludedEmbedMetadataKeys());
                    updatedEmbedExcludeKeys.addAll(toUpdateFormatter.getExcludedEmbedMetadataKeys());
                    ArrayList<String> updatedInterfaceExcludeKeys = new ArrayList<String>(docFormatter.getExcludedInferenceMetadataKeys());
                    updatedInterfaceExcludeKeys.addAll(toUpdateFormatter.getExcludedInferenceMetadataKeys());
                    DefaultContentFormatter.Builder builder = DefaultContentFormatter.builder().withExcludedEmbedMetadataKeys(updatedEmbedExcludeKeys).withExcludedInferenceMetadataKeys(updatedInterfaceExcludeKeys).withMetadataTemplate(docFormatter.getMetadataTemplate()).withMetadataSeparator(docFormatter.getMetadataSeparator());
                    if (!this.disableTemplateRewrite) {
                        builder.withTextTemplate(docFormatter.getTextTemplate());
                    }
                    document.setContentFormatter(builder.build());
                } else {
                    document.setContentFormatter(this.contentFormatter);
                }
            });
        }
        return documents;
    }
}

