/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentReader;
import org.springframework.ai.reader.EmptyJsonMetadataGenerator;
import org.springframework.ai.reader.JsonMetadataGenerator;
import org.springframework.core.io.Resource;

public class JsonReader
implements DocumentReader {
    private Resource resource;
    private JsonMetadataGenerator jsonMetadataGenerator;
    private List<String> jsonKeysToUse;

    public JsonReader(Resource resource) {
        this(resource, new ArrayList().toArray(new String[0]));
    }

    public JsonReader(Resource resource, String ... jsonKeysToUse) {
        this(resource, new EmptyJsonMetadataGenerator(), jsonKeysToUse);
    }

    public JsonReader(Resource resource, JsonMetadataGenerator jsonMetadataGenerator, String ... jsonKeysToUse) {
        Objects.requireNonNull(jsonKeysToUse, "keys must not be null");
        Objects.requireNonNull(jsonMetadataGenerator, "jsonMetadataGenerator must not be null");
        Objects.requireNonNull(resource, "The Spring Resource must not be null");
        this.resource = resource;
        this.jsonMetadataGenerator = jsonMetadataGenerator;
        this.jsonKeysToUse = List.of(jsonKeysToUse);
    }

    @Override
    public List<Document> get() {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            List jsonData = (List)objectMapper.readValue(this.resource.getInputStream(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            for (Map item : jsonData) {
                StringBuilder sb = new StringBuilder();
                for (String key : this.jsonKeysToUse) {
                    if (!item.containsKey(key)) continue;
                    sb.append(key);
                    sb.append(": ");
                    sb.append(item.get(key));
                    sb.append(System.lineSeparator());
                }
                Map<String, Object> metadata = this.jsonMetadataGenerator.generate(item);
                Document document = !sb.isEmpty() ? new Document(sb.toString(), metadata) : new Document(item.toString(), metadata);
                documents.add(document);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return documents;
    }
}

