/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader;

import org.springframework.util.StringUtils;

public class ExtractedTextFormatter {
    private boolean leftAlignment;
    private int numberOfTopPagesToSkipBeforeDelete;
    private int numberOfTopTextLinesToDelete;
    private int numberOfBottomTextLinesToDelete;

    private ExtractedTextFormatter(Builder builder) {
        this.leftAlignment = builder.leftAlignment;
        this.numberOfBottomTextLinesToDelete = builder.numberOfBottomTextLinesToDelete;
        this.numberOfTopPagesToSkipBeforeDelete = builder.numberOfTopPagesToSkipBeforeDelete;
        this.numberOfTopTextLinesToDelete = builder.numberOfTopTextLinesToDelete;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExtractedTextFormatter defaults() {
        return new Builder().build();
    }

    public String format(String pageText) {
        return this.format(pageText, 0);
    }

    public String format(String pageText, int pageNumber) {
        String text = ExtractedTextFormatter.trimAdjacentBlankLines(pageText);
        if (pageNumber >= this.numberOfTopPagesToSkipBeforeDelete) {
            text = ExtractedTextFormatter.deleteTopTextLines(text, this.numberOfTopTextLinesToDelete);
            text = ExtractedTextFormatter.deleteBottomTextLines(text, this.numberOfBottomTextLinesToDelete);
        }
        if (this.leftAlignment) {
            text = ExtractedTextFormatter.alignToLeft(text);
        }
        return text;
    }

    public static String trimAdjacentBlankLines(String pageText) {
        return pageText.replaceAll("(?m)(^ *\n)", "\n").replaceAll("(?m)^$([\r\n]+?)(^$[\r\n]+?^)+", "$1");
    }

    public static String alignToLeft(String pageText) {
        return pageText.replaceAll("(?m)(^ *| +(?= |$))", "").replaceAll("(?m)^$(\t?)(^$[\r\n]+?^)+", "$1");
    }

    public static String deleteBottomTextLines(String pageText, int numberOfLines) {
        int truncateIndex;
        if (!StringUtils.hasText((String)pageText)) {
            return pageText;
        }
        int nextTruncateIndex = truncateIndex = pageText.length();
        for (int lineCount = 0; lineCount < numberOfLines && nextTruncateIndex >= 0; ++lineCount) {
            nextTruncateIndex = pageText.lastIndexOf(System.lineSeparator(), truncateIndex - 1);
            truncateIndex = nextTruncateIndex < 0 ? truncateIndex : nextTruncateIndex;
        }
        return pageText.substring(0, truncateIndex);
    }

    public static String deleteTopTextLines(String pageText, int numberOfLines) {
        int truncateIndex;
        if (!StringUtils.hasText((String)pageText)) {
            return pageText;
        }
        int nextTruncateIndex = truncateIndex = 0;
        for (int lineCount = 0; lineCount < numberOfLines && nextTruncateIndex >= 0; ++lineCount) {
            nextTruncateIndex = pageText.indexOf(System.lineSeparator(), truncateIndex + 1);
            truncateIndex = nextTruncateIndex < 0 ? truncateIndex : nextTruncateIndex;
        }
        return pageText.substring(truncateIndex, pageText.length());
    }

    public static class Builder {
        private boolean leftAlignment = false;
        private int numberOfTopPagesToSkipBeforeDelete = 0;
        private int numberOfTopTextLinesToDelete = 0;
        private int numberOfBottomTextLinesToDelete = 0;

        public Builder withLeftAlignment(boolean leftAlignment) {
            this.leftAlignment = leftAlignment;
            return this;
        }

        public Builder withNumberOfTopPagesToSkipBeforeDelete(int numberOfTopPagesToSkipBeforeDelete) {
            this.numberOfTopPagesToSkipBeforeDelete = numberOfTopPagesToSkipBeforeDelete;
            return this;
        }

        public Builder withNumberOfTopTextLinesToDelete(int numberOfTopTextLinesToDelete) {
            this.numberOfTopTextLinesToDelete = numberOfTopTextLinesToDelete;
            return this;
        }

        public Builder withNumberOfBottomTextLinesToDelete(int numberOfBottomTextLinesToDelete) {
            this.numberOfBottomTextLinesToDelete = numberOfBottomTextLinesToDelete;
            return this;
        }

        public ExtractedTextFormatter build() {
            return new ExtractedTextFormatter(this);
        }
    }
}

