/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.parser;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.parser.AbstractMessageConverterOutputParser;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;

public class MapOutputParser
extends AbstractMessageConverterOutputParser<Map<String, Object>> {
    public MapOutputParser() {
        super((MessageConverter)new MappingJackson2MessageConverter());
    }

    @Override
    public Map<String, Object> parse(String text) {
        Message message = MessageBuilder.withPayload((Object)text.getBytes(StandardCharsets.UTF_8)).build();
        return (Map)this.getMessageConverter().fromMessage(message, HashMap.class);
    }

    @Override
    public String getFormat() {
        String raw = "Your response should be in JSON format.\nThe data structure for the JSON should match this Java class: %s\nDo not include any explanations, only provide a RFC8259 compliant JSON response following this format without deviation.\n";
        return String.format(raw, "java.util.HashMap");
    }
}

