/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.parser.OutputParser;

public class BeanOutputParser<T>
implements OutputParser<T> {
    private String jsonSchema;
    private Class<T> clazz;
    private ObjectMapper objectMapper;

    public BeanOutputParser(Class<T> clazz) {
        this(clazz, null);
    }

    public BeanOutputParser(Class<T> clazz, ObjectMapper objectMapper) {
        Objects.requireNonNull(clazz, "Java Class cannot be null;");
        this.clazz = clazz;
        this.objectMapper = objectMapper != null ? objectMapper : this.getObjectMapper();
        this.generateSchema();
    }

    private void generateSchema() {
        JacksonModule jacksonModule = new JacksonModule();
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule);
        SchemaGeneratorConfig config = configBuilder.build();
        SchemaGenerator generator = new SchemaGenerator(config);
        ObjectNode jsonNode = generator.generateSchema(this.clazz, new Type[0]);
        ObjectWriter objectWriter = new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed(System.lineSeparator())));
        try {
            this.jsonSchema = objectWriter.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not pretty print json schema for " + String.valueOf(this.clazz), e);
        }
    }

    @Override
    public T parse(String text) {
        try {
            text = this.jsonSchemaToInstance(text);
            return (T)this.objectMapper.readValue(text, this.clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String jsonSchemaToInstance(String text) {
        try {
            Map map = (Map)this.objectMapper.readValue(text, Map.class);
            if (map.containsKey("$schema")) {
                return this.objectMapper.writeValueAsString(map.get("properties"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @Override
    public String getFormat() {
        String template = "Your response should be in JSON format.\nDo not include any explanations, only provide a RFC8259 compliant JSON response following this format without deviation.\nDo not include markdown code blocks in your response.\nHere is the JSON Schema instance your output must adhere to:\n%s\n";
        return String.format(template, this.jsonSchema);
    }
}

