/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import net.jodah.typetools.TypeResolver;

public class TypeResolverHelper {
    public static Class<?> getFunctionInputClass(Class<? extends Function<?, ?>> functionClass) {
        return TypeResolverHelper.getFunctionArgumentClass(functionClass, 0);
    }

    public static Class<?> getFunctionOutputClass(Class<? extends Function<?, ?>> functionClass) {
        return TypeResolverHelper.getFunctionArgumentClass(functionClass, 1);
    }

    public static Class<?> getFunctionArgumentClass(Class<? extends Function<?, ?>> functionClass, int argumentIndex) {
        Type type = TypeResolver.reify(Function.class, functionClass);
        Class<Object> argumentType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[argumentIndex] : Object.class;
        return TypeResolverHelper.toRawClass(argumentType);
    }

    public static Type getFunctionInputType(Class<? extends Function<?, ?>> functionClass) {
        return TypeResolverHelper.getFunctionArgumentType(functionClass, 0);
    }

    public static Type getFunctionOutputType(Class<? extends Function<?, ?>> functionClass) {
        return TypeResolverHelper.getFunctionArgumentType(functionClass, 1);
    }

    public static Type getFunctionArgumentType(Class<? extends Function<?, ?>> functionClass, int argumentIndex) {
        Type functionType = TypeResolver.reify(Function.class, functionClass);
        return TypeResolverHelper.getFunctionArgumentType(functionType, argumentIndex);
    }

    public static Type getFunctionArgumentType(Type functionType, int argumentIndex) {
        Class<Object> argumentType = functionType instanceof ParameterizedType ? ((ParameterizedType)functionType).getActualTypeArguments()[argumentIndex] : Object.class;
        return argumentType;
    }

    public static Class<?> toRawClass(Type type) {
        return type != null ? TypeResolver.resolveRawClass((Type)(type instanceof GenericArrayType ? type : TypeResolver.reify((Type)type)), null) : null;
    }
}

