/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.Assert;

public class FunctionCallingOptionsBuilder {
    private final PortableFunctionCallingOptions options = new PortableFunctionCallingOptions();

    public FunctionCallingOptionsBuilder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.options.setFunctionCallbacks(functionCallbacks);
        return this;
    }

    public FunctionCallingOptionsBuilder withFunctionCallback(FunctionCallback functionCallback) {
        Assert.notNull((Object)functionCallback, (String)"FunctionCallback must not be null");
        this.options.getFunctionCallbacks().add(functionCallback);
        return this;
    }

    public FunctionCallingOptionsBuilder withFunctions(Set<String> functions) {
        this.options.setFunctions(functions);
        return this;
    }

    public FunctionCallingOptionsBuilder withFunction(String function) {
        Assert.notNull((Object)function, (String)"Function must not be null");
        this.options.getFunctions().add(function);
        return this;
    }

    public FunctionCallingOptionsBuilder withTemperature(Float temperature) {
        this.options.setTemperature(temperature);
        return this;
    }

    public FunctionCallingOptionsBuilder withTopP(Float topP) {
        this.options.setTopP(topP);
        return this;
    }

    public FunctionCallingOptionsBuilder withTopK(Integer topK) {
        this.options.setTopK(topK);
        return this;
    }

    public PortableFunctionCallingOptions build() {
        return this.options;
    }

    public static class PortableFunctionCallingOptions
    implements FunctionCallingOptions,
    ChatOptions {
        private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
        private Set<String> functions = new HashSet<String>();
        private Float temperature;
        private Float topP;
        private Integer topK;

        @Override
        public List<FunctionCallback> getFunctionCallbacks() {
            return this.functionCallbacks;
        }

        @Override
        public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            Assert.notNull(functionCallbacks, (String)"FunctionCallbacks must not be null");
            this.functionCallbacks = functionCallbacks;
        }

        @Override
        public Set<String> getFunctions() {
            return this.functions;
        }

        @Override
        public void setFunctions(Set<String> functions) {
            Assert.notNull(functions, (String)"Functions must not be null");
            this.functions = functions;
        }

        @Override
        public Float getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public Float getTopP() {
            return this.topP;
        }

        public void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public Integer getTopK() {
            return this.topK;
        }

        public void setTopK(Integer topK) {
            this.topK = topK;
        }
    }
}

