/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.function.Function;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.AbstractFunctionCallback;
import org.springframework.ai.model.function.TypeResolverHelper;
import org.springframework.util.Assert;

public class FunctionCallbackWrapper<I, O>
extends AbstractFunctionCallback<I, O> {
    private final Function<I, O> function;

    private FunctionCallbackWrapper(String name, String description, String inputTypeSchema, Class<I> inputType, Function<O, String> responseConverter, ObjectMapper objectMapper, Function<I, O> function) {
        super(name, description, inputTypeSchema, inputType, responseConverter, objectMapper);
        Assert.notNull(function, (String)"Function must not be null");
        this.function = function;
    }

    private static <I, O> Class<I> resolveInputType(Function<I, O> function) {
        return TypeResolverHelper.getFunctionInputClass(function.getClass());
    }

    @Override
    public O apply(I input) {
        return this.function.apply(input);
    }

    public static <I, O> Builder<I, O> builder(Function<I, O> function) {
        return new Builder<I, O>(function);
    }

    public static class Builder<I, O> {
        private String name;
        private String description;
        private Class<I> inputType;
        private final Function<I, O> function;
        private SchemaType schemaType = SchemaType.JSON_SCHEMA;
        private Function<O, String> responseConverter = response -> ModelOptionsUtils.toJsonString(response);
        private String inputTypeSchema;
        private ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).registerModule((Module)new JavaTimeModule());

        public Builder(Function<I, O> function) {
            Assert.notNull(function, (String)"Function must not be null");
            this.function = function;
        }

        public Builder<I, O> withName(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            this.name = name;
            return this;
        }

        public Builder<I, O> withDescription(String description) {
            Assert.hasText((String)description, (String)"Description must not be empty");
            this.description = description;
            return this;
        }

        public Builder<I, O> withInputType(Class<?> inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder<I, O> withResponseConverter(Function<O, String> responseConverter) {
            Assert.notNull(responseConverter, (String)"ResponseConverter must not be null");
            this.responseConverter = responseConverter;
            return this;
        }

        public Builder<I, O> withInputTypeSchema(String inputTypeSchema) {
            Assert.hasText((String)inputTypeSchema, (String)"InputTypeSchema must not be empty");
            this.inputTypeSchema = inputTypeSchema;
            return this;
        }

        public Builder<I, O> withObjectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder<I, O> withSchemaType(SchemaType schemaType) {
            Assert.notNull((Object)((Object)schemaType), (String)"SchemaType must not be null");
            this.schemaType = schemaType;
            return this;
        }

        public FunctionCallbackWrapper<I, O> build() {
            Assert.hasText((String)this.name, (String)"Name must not be empty");
            Assert.hasText((String)this.description, (String)"Description must not be empty");
            Assert.notNull(this.function, (String)"Function must not be null");
            Assert.notNull(this.responseConverter, (String)"ResponseConverter must not be null");
            Assert.notNull((Object)this.objectMapper, (String)"ObjectMapper must not be null");
            if (this.inputType == null) {
                this.inputType = FunctionCallbackWrapper.resolveInputType(this.function);
            }
            if (this.inputTypeSchema == null) {
                boolean upperCaseTypeValues = this.schemaType == SchemaType.OPEN_API_SCHEMA;
                this.inputTypeSchema = ModelOptionsUtils.getJsonSchema(this.inputType, upperCaseTypeValues);
            }
            return new FunctionCallbackWrapper<I, O>(this.name, this.description, this.inputTypeSchema, this.inputType, this.responseConverter, this.objectMapper, this.function);
        }

        public static enum SchemaType {
            JSON_SCHEMA,
            OPEN_API_SCHEMA;

        }
    }
}

