/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackWrapper;
import org.springframework.ai.model.function.TypeResolverHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Description;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class FunctionCallbackContext
implements ApplicationContextAware {
    private GenericApplicationContext applicationContext;
    private FunctionCallbackWrapper.Builder.SchemaType schemaType = FunctionCallbackWrapper.Builder.SchemaType.JSON_SCHEMA;

    public void setSchemaType(FunctionCallbackWrapper.Builder.SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    public FunctionCallback getFunctionCallback(@NonNull String beanName, @Nullable String defaultDescription) {
        Object bean;
        Type beanType = FunctionContextUtils.findType((ConfigurableListableBeanFactory)this.applicationContext.getBeanFactory(), (String[])new String[]{beanName});
        if (beanType == null) {
            throw new IllegalArgumentException("Functional bean with name: " + beanName + " does not exist in the context.");
        }
        if (!Function.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)beanType))) {
            throw new IllegalArgumentException("Function call Bean must be of type Function. Found: " + beanType.getTypeName());
        }
        Type functionInputType = TypeResolverHelper.getFunctionArgumentType(beanType, 0);
        Class functionInputClass = FunctionTypeUtils.getRawType((Type)functionInputType);
        String functionName = beanName;
        String functionDescription = defaultDescription;
        if (!StringUtils.hasText((String)functionDescription)) {
            JsonClassDescription jsonClassDescriptionAnnotation;
            Description descriptionAnnotation = (Description)this.applicationContext.findAnnotationOnBean(beanName, Description.class);
            if (descriptionAnnotation != null) {
                functionDescription = descriptionAnnotation.value();
            }
            if (!StringUtils.hasText((String)functionDescription) && (jsonClassDescriptionAnnotation = functionInputClass.getAnnotation(JsonClassDescription.class)) != null) {
                functionDescription = jsonClassDescriptionAnnotation.value();
            }
            if (!StringUtils.hasText((String)functionDescription)) {
                throw new IllegalStateException("Could not determine function description.Please provide a description either as a default parameter, via @Description annotation on the bean or @JsonClassDescription annotation on the input class.");
            }
        }
        if ((bean = this.applicationContext.getBean(beanName)) instanceof Function) {
            Function function = (Function)bean;
            return FunctionCallbackWrapper.builder(function).withName(functionName).withSchemaType(this.schemaType).withDescription(functionDescription).withInputType(functionInputClass).build();
        }
        throw new IllegalArgumentException("Bean must be of type Function");
    }
}

