/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.util.Assert;

abstract class AbstractFunctionCallback<I, O>
implements Function<I, O>,
FunctionCallback {
    private final String name;
    private final String description;
    private final Class<I> inputType;
    private final String inputTypeSchema;
    private final ObjectMapper objectMapper;
    private final Function<O, String> responseConverter;

    protected AbstractFunctionCallback(String name, String description, String inputTypeSchema, Class<I> inputType, Function<O, String> responseConverter, ObjectMapper objectMapper) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)description, (String)"Description must not be null");
        Assert.notNull(inputType, (String)"InputType must not be null");
        Assert.notNull((Object)inputTypeSchema, (String)"InputTypeSchema must not be null");
        Assert.notNull(responseConverter, (String)"ResponseConverter must not be null");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.name = name;
        this.description = description;
        this.inputType = inputType;
        this.inputTypeSchema = inputTypeSchema;
        this.responseConverter = responseConverter;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getInputTypeSchema() {
        return this.inputTypeSchema;
    }

    @Override
    public String call(String functionArguments) {
        I request = this.fromJson(functionArguments, this.inputType);
        return this.andThen(this.responseConverter).apply(request);
    }

    private <T> T fromJson(String json, Class<T> targetClass) {
        try {
            return (T)this.objectMapper.readValue(json, targetClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.inputType == null ? 0 : this.inputType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFunctionCallback other = (AbstractFunctionCallback)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.inputType == null ? other.inputType != null : !this.inputType.equals(other.inputType));
    }
}

