/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.CollectionUtils;

public abstract class AbstractFunctionCallSupport<Msg, Req, Resp> {
    protected static final boolean IS_RUNTIME_CALL = true;
    protected final Map<String, FunctionCallback> functionCallbackRegister = new ConcurrentHashMap<String, FunctionCallback>();
    protected final FunctionCallbackContext functionCallbackContext;

    protected AbstractFunctionCallSupport(FunctionCallbackContext functionCallbackContext) {
        this.functionCallbackContext = functionCallbackContext;
    }

    public Map<String, FunctionCallback> getFunctionCallbackRegister() {
        return this.functionCallbackRegister;
    }

    protected Set<String> handleFunctionCallbackConfigurations(FunctionCallingOptions options, boolean isRuntimeCall) {
        HashSet<String> functionToCall = new HashSet<String>();
        if (options != null) {
            if (!CollectionUtils.isEmpty(options.getFunctionCallbacks())) {
                options.getFunctionCallbacks().stream().forEach(functionCallback -> {
                    if (isRuntimeCall) {
                        this.functionCallbackRegister.put(functionCallback.getName(), (FunctionCallback)functionCallback);
                    } else {
                        this.functionCallbackRegister.putIfAbsent(functionCallback.getName(), (FunctionCallback)functionCallback);
                    }
                    if (isRuntimeCall) {
                        functionToCall.add(functionCallback.getName());
                    }
                });
            }
            if (!CollectionUtils.isEmpty(options.getFunctions())) {
                functionToCall.addAll(options.getFunctions());
            }
        }
        return functionToCall;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<FunctionCallback> resolveFunctionCallbacks(Set<String> functionNames) {
        ArrayList<FunctionCallback> retrievedFunctionCallbacks = new ArrayList<FunctionCallback>();
        for (String functionName : functionNames) {
            FunctionCallback functionCallback;
            if (!this.functionCallbackRegister.containsKey(functionName)) {
                if (this.functionCallbackContext == null) throw new IllegalStateException("No function callback found for name: " + functionName);
                functionCallback = this.functionCallbackContext.getFunctionCallback(functionName, null);
                if (functionCallback == null) throw new IllegalStateException("No function callback [" + functionName + "] fund in tht FunctionCallbackContext");
                this.functionCallbackRegister.put(functionName, functionCallback);
            }
            functionCallback = this.functionCallbackRegister.get(functionName);
            retrievedFunctionCallbacks.add(functionCallback);
        }
        return retrievedFunctionCallbacks;
    }

    protected Resp callWithFunctionSupport(Req request) {
        Resp response = this.doChatCompletion(request);
        return this.handleFunctionCallOrReturn(request, response);
    }

    protected Resp handleFunctionCallOrReturn(Req request, Resp response) {
        if (!this.isToolFunctionCall(response)) {
            return response;
        }
        ArrayList<Msg> conversationHistory = new ArrayList<Msg>();
        conversationHistory.addAll(this.doGetUserMessages(request));
        Msg responseMessage = this.doGetToolResponseMessage(response);
        conversationHistory.add(responseMessage);
        Req newRequest = this.doCreateToolResponseRequest(request, responseMessage, conversationHistory);
        return this.callWithFunctionSupport(newRequest);
    }

    protected abstract Req doCreateToolResponseRequest(Req var1, Msg var2, List<Msg> var3);

    protected abstract List<Msg> doGetUserMessages(Req var1);

    protected abstract Msg doGetToolResponseMessage(Resp var1);

    protected abstract Resp doChatCompletion(Req var1);

    protected abstract boolean isToolFunctionCall(Resp var1);
}

