/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.image;

import org.springframework.ai.image.ImageOptions;

public class ImageOptionsBuilder {
    private final ImageModelOptionsImpl options = new ImageModelOptionsImpl();

    private ImageOptionsBuilder() {
    }

    public static ImageOptionsBuilder builder() {
        return new ImageOptionsBuilder();
    }

    public ImageOptionsBuilder withN(Integer n) {
        this.options.setN(n);
        return this;
    }

    public ImageOptionsBuilder withModel(String model) {
        this.options.setModel(model);
        return this;
    }

    public ImageOptionsBuilder withResponseFormat(String responseFormat) {
        this.options.setResponseFormat(responseFormat);
        return this;
    }

    public ImageOptionsBuilder withWidth(Integer width) {
        this.options.setWidth(width);
        return this;
    }

    public ImageOptionsBuilder withHeight(Integer height) {
        this.options.setHeight(height);
        return this;
    }

    public ImageOptions build() {
        return this.options;
    }

    private class ImageModelOptionsImpl
    implements ImageOptions {
        private Integer n;
        private String model;
        private Integer width;
        private Integer height;
        private String responseFormat;

        private ImageModelOptionsImpl() {
        }

        @Override
        public Integer getN() {
            return this.n;
        }

        public void setN(Integer n) {
            this.n = n;
        }

        @Override
        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        @Override
        public String getResponseFormat() {
            return this.responseFormat;
        }

        public void setResponseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
        }

        @Override
        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }
    }
}

