/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.model.ModelResponse;
import org.springframework.util.Assert;

public class EmbeddingResponse
implements ModelResponse<Embedding> {
    private List<Embedding> embeddings;
    private EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();

    public EmbeddingResponse(List<Embedding> embeddings) {
        this(embeddings, new EmbeddingResponseMetadata());
    }

    public EmbeddingResponse(List<Embedding> embeddings, EmbeddingResponseMetadata metadata) {
        this.embeddings = embeddings;
        this.metadata = metadata;
    }

    @Override
    public EmbeddingResponseMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Embedding getResult() {
        Assert.notEmpty(this.embeddings, (String)"No embedding data available.");
        return this.embeddings.get(0);
    }

    @Override
    public List<Embedding> getResults() {
        return this.embeddings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingResponse that = (EmbeddingResponse)o;
        return Objects.equals(this.embeddings, that.embeddings) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.embeddings, this.metadata);
    }

    public String toString() {
        return "EmbeddingResult{data=" + String.valueOf(this.embeddings) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }
}

