/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.util.List;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.ModelClient;
import org.springframework.util.Assert;

public interface EmbeddingClient
extends ModelClient<EmbeddingRequest, EmbeddingResponse> {
    @Override
    public EmbeddingResponse call(EmbeddingRequest var1);

    default public List<Double> embed(String text) {
        Assert.notNull((Object)text, (String)"Text must not be null");
        return this.embed(List.of(text)).iterator().next();
    }

    public List<Double> embed(Document var1);

    default public List<List<Double>> embed(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, EmbeddingOptions.EMPTY)).getResults().stream().map(Embedding::getOutput).toList();
    }

    default public EmbeddingResponse embedForResponse(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, EmbeddingOptions.EMPTY));
    }

    default public int dimensions() {
        return this.embed("Test String").size();
    }
}

