/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.embedding.EmbeddingResultMetadata;
import org.springframework.ai.model.ModelResult;

public class Embedding
implements ModelResult<List<Double>> {
    private List<Double> embedding;
    private Integer index;
    private EmbeddingResultMetadata metadata;

    public Embedding(List<Double> embedding, Integer index) {
        this.embedding = embedding;
        this.index = index;
    }

    @Override
    public List<Double> getOutput() {
        return this.embedding;
    }

    public Integer getIndex() {
        return this.index;
    }

    @Override
    public EmbeddingResultMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Embedding embedding1 = (Embedding)o;
        return Objects.equals(this.embedding, embedding1.embedding) && Objects.equals(this.index, embedding1.index);
    }

    public int hashCode() {
        return Objects.hash(this.embedding, this.index);
    }

    public String toString() {
        String message = this.embedding.isEmpty() ? "<empty>" : "<has data>";
        return "Embedding{embedding=" + message + ", index=" + this.index + "}";
    }
}

