/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.core.io.DefaultResourceLoader;

public abstract class AbstractEmbeddingClient
implements EmbeddingClient {
    protected final AtomicInteger embeddingDimensions = new AtomicInteger(-1);
    private static Map<String, Integer> KNOWN_EMBEDDING_DIMENSIONS = AbstractEmbeddingClient.loadKnownModelDimensions();

    public static int dimensions(EmbeddingClient embeddingClient, String modelName, String dummyContent) {
        if (KNOWN_EMBEDDING_DIMENSIONS.containsKey(modelName)) {
            return KNOWN_EMBEDDING_DIMENSIONS.get(modelName);
        }
        return embeddingClient.embed(dummyContent).size();
    }

    private static Map<String, Integer> loadKnownModelDimensions() {
        try {
            Properties properties = new Properties();
            properties.load(new DefaultResourceLoader().getResource("classpath:/embedding/embedding-model-dimensions.properties").getInputStream());
            return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> Integer.parseInt(e.getValue().toString())));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int dimensions() {
        if (this.embeddingDimensions.get() < 0) {
            this.embeddingDimensions.set(AbstractEmbeddingClient.dimensions(this, "Test", "Hello World"));
        }
        return this.embeddingDimensions.get();
    }
}

