/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.document;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.document.ContentFormatter;
import org.springframework.ai.document.DefaultContentFormatter;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.document.id.IdGenerator;
import org.springframework.ai.document.id.RandomIdGenerator;
import org.springframework.util.Assert;

@JsonIgnoreProperties(value={"contentFormatter"})
public class Document {
    public static final ContentFormatter DEFAULT_CONTENT_FORMATTER = DefaultContentFormatter.defaultConfig();
    private final String id;
    private Map<String, Object> metadata;
    private String content;
    @JsonProperty(index=100)
    private List<Double> embedding = new ArrayList<Double>();
    @JsonIgnore
    private ContentFormatter contentFormatter = DEFAULT_CONTENT_FORMATTER;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public Document(@JsonProperty(value="content") String content) {
        this(content, new HashMap<String, Object>());
    }

    public Document(String content, Map<String, Object> metadata) {
        this(content, metadata, new RandomIdGenerator());
    }

    public Document(String content, Map<String, Object> metadata, IdGenerator idGenerator) {
        this(idGenerator.generateId(content, metadata), content, metadata);
    }

    public Document(String id, String content, Map<String, Object> metadata) {
        Assert.hasText((String)id, (String)"id must not be null");
        Assert.hasText((String)content, (String)"content must not be null");
        Assert.notNull(metadata, (String)"metadata must not be null");
        this.id = id;
        this.content = content;
        this.metadata = metadata;
    }

    public String getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    @JsonIgnore
    public String getFormattedContent() {
        return this.getFormattedContent(MetadataMode.ALL);
    }

    public String getFormattedContent(MetadataMode metadataMode) {
        Assert.notNull((Object)((Object)metadataMode), (String)"Metadata mode must not be null");
        return this.contentFormatter.format(this, metadataMode);
    }

    public String getFormattedContent(ContentFormatter formatter, MetadataMode metadataMode) {
        Assert.notNull((Object)formatter, (String)"formatter must not be null");
        Assert.notNull((Object)((Object)metadataMode), (String)"Metadata mode must not be null");
        return formatter.format(this, metadataMode);
    }

    public void setEmbedding(List<Double> embedding) {
        Assert.notNull(embedding, (String)"embedding must not be null");
        this.embedding = embedding;
    }

    public void setContentFormatter(ContentFormatter contentFormatter) {
        this.contentFormatter = contentFormatter;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<Double> getEmbedding() {
        return this.embedding;
    }

    public ContentFormatter getContentFormatter() {
        return this.contentFormatter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }

    public String toString() {
        return "Document{id='" + this.id + "', metadata=" + String.valueOf(this.metadata) + ", content='" + new String(this.content) + "'}";
    }
}

