/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.springframework.ai.chat.messages.Media;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplateActions;
import org.springframework.ai.chat.prompt.PromptTemplateMessageActions;
import org.springframework.ai.chat.prompt.TemplateFormat;
import org.springframework.ai.parser.OutputParser;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import org.stringtemplate.v4.ST;

public class PromptTemplate
implements PromptTemplateActions,
PromptTemplateMessageActions {
    private ST st;
    private Map<String, Object> dynamicModel = new HashMap<String, Object>();
    protected String template;
    protected TemplateFormat templateFormat = TemplateFormat.ST;
    private OutputParser outputParser;

    public PromptTemplate(Resource resource) {
        try (InputStream inputStream = resource.getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read resource", ex);
        }
        try {
            this.st = new ST(this.template, '{', '}');
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    public PromptTemplate(String template) {
        this.template = template;
        try {
            this.st = new ST(this.template, '{', '}');
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    public PromptTemplate(String template, Map<String, Object> model) {
        this.template = template;
        try {
            this.st = new ST(this.template, '{', '}');
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
                this.dynamicModel.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    public PromptTemplate(Resource resource, Map<String, Object> model) {
        try (InputStream inputStream = resource.getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read resource", ex);
        }
        try {
            this.st = new ST(this.template, '{', '}');
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
                this.dynamicModel.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The template string is not valid.", ex);
        }
    }

    public OutputParser getOutputParser() {
        return this.outputParser;
    }

    public void setOutputParser(OutputParser outputParser) {
        Objects.requireNonNull(outputParser, "Output Parser can not be null");
        this.outputParser = outputParser;
    }

    public void add(String name, Object value) {
        this.st.add(name, value);
        this.dynamicModel.put(name, value);
    }

    public String getTemplate() {
        return this.template;
    }

    public TemplateFormat getTemplateFormat() {
        return this.templateFormat;
    }

    @Override
    public String render() {
        this.validate(this.dynamicModel);
        return this.st.render();
    }

    @Override
    public String render(Map<String, Object> model) {
        this.validate(model);
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (this.st.getAttribute(entry.getKey()) != null) {
                this.st.remove(entry.getKey());
            }
            if (entry.getValue() instanceof Resource) {
                this.st.add(entry.getKey(), (Object)this.renderResource((Resource)entry.getValue()));
                continue;
            }
            this.st.add(entry.getKey(), entry.getValue());
        }
        return this.st.render();
    }

    private String renderResource(Resource resource) {
        try {
            return resource.getContentAsString(Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Message createMessage() {
        return new UserMessage(this.render());
    }

    @Override
    public Message createMessage(List<Media> mediaList) {
        return new UserMessage(this.render(), mediaList);
    }

    @Override
    public Message createMessage(Map<String, Object> model) {
        return new UserMessage(this.render(model));
    }

    @Override
    public Prompt create() {
        return new Prompt(this.render(new HashMap<String, Object>()));
    }

    @Override
    public Prompt create(Map<String, Object> model) {
        return new Prompt(this.render(model));
    }

    public Set<String> getInputVariables() {
        TokenStream tokens = this.st.impl.tokens;
        return IntStream.range(0, tokens.range()).mapToObj(arg_0 -> ((TokenStream)tokens).get(arg_0)).filter(token -> token.getType() == 25).map(Token::getText).collect(Collectors.toSet());
    }

    protected void validate(Map<String, Object> model) {
        HashSet<String> dynamicVariableNames = new HashSet<String>(this.dynamicModel.keySet());
        HashSet<String> modelVariables = new HashSet<String>(model.keySet());
        modelVariables.addAll(dynamicVariableNames);
        HashSet<String> missingEntries = new HashSet<String>(this.getInputVariables());
        missingEntries.removeAll(modelVariables);
        if (!missingEntries.isEmpty()) {
            throw new IllegalStateException("All template variables were not replaced. Missing variable names are " + String.valueOf(missingEntries));
        }
    }
}

