/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelRequest;

public class Prompt
implements ModelRequest<List<Message>> {
    private final List<Message> messages;
    private ChatOptions modelOptions;

    public Prompt(String contents) {
        this(new UserMessage(contents));
    }

    public Prompt(Message message) {
        this(Collections.singletonList(message));
    }

    public Prompt(List<Message> messages) {
        this.messages = messages;
    }

    public Prompt(String contents, ChatOptions modelOptions) {
        this(new UserMessage(contents), modelOptions);
    }

    public Prompt(Message message, ChatOptions modelOptions) {
        this(Collections.singletonList(message), modelOptions);
    }

    public Prompt(List<Message> messages, ChatOptions modelOptions) {
        this.messages = messages;
        this.modelOptions = modelOptions;
    }

    public String getContents() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.getInstructions().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            sb.append(message.getContent());
        }
        return sb.toString();
    }

    @Override
    public ModelOptions getOptions() {
        return this.modelOptions;
    }

    @Override
    public List<Message> getInstructions() {
        return this.messages;
    }

    public String toString() {
        return "Prompt{messages=" + String.valueOf(this.messages) + ", modelOptions=" + String.valueOf(this.modelOptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Prompt)) {
            return false;
        }
        Prompt prompt = (Prompt)o;
        return Objects.equals(this.messages, prompt.messages) && Objects.equals(this.modelOptions, prompt.modelOptions);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.modelOptions);
    }
}

