/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import org.springframework.ai.chat.prompt.ChatOptions;

public class ChatOptionsBuilder {
    private final ChatOptionsImpl options = new ChatOptionsImpl();

    private ChatOptionsBuilder() {
    }

    public static ChatOptionsBuilder builder() {
        return new ChatOptionsBuilder();
    }

    public ChatOptionsBuilder withTemperature(Float temperature) {
        this.options.setTemperature(temperature);
        return this;
    }

    public ChatOptionsBuilder withTopP(Float topP) {
        this.options.setTopP(topP);
        return this;
    }

    public ChatOptionsBuilder withTopK(Integer topK) {
        this.options.setTopK(topK);
        return this;
    }

    public ChatOptions build() {
        return this.options;
    }

    private class ChatOptionsImpl
    implements ChatOptions {
        private Float temperature;
        private Float topP;
        private Integer topK;

        private ChatOptionsImpl() {
        }

        @Override
        public Float getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public Float getTopP() {
            return this.topP;
        }

        public void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public Integer getTopK() {
            return this.topK;
        }

        public void setTopK(Integer topK) {
            this.topK = topK;
        }
    }
}

