/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.metadata;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.util.Assert;

@FunctionalInterface
public interface PromptMetadata
extends Iterable<PromptFilterMetadata> {
    public static PromptMetadata empty() {
        return PromptMetadata.of(new PromptFilterMetadata[0]);
    }

    public static <T> PromptMetadata of(PromptFilterMetadata ... array) {
        return PromptMetadata.of(Arrays.asList(array));
    }

    public static PromptMetadata of(Iterable<PromptFilterMetadata> iterable) {
        Assert.notNull(iterable, (String)"An Iterable of PromptFilterMetadata must not be null");
        return iterable::iterator;
    }

    default public Optional<PromptFilterMetadata> findByPromptIndex(int promptIndex) {
        Assert.isTrue((promptIndex > -1 ? 1 : 0) != 0, (String)"Prompt index [%d] must be greater than equal to 0".formatted(promptIndex));
        return StreamSupport.stream(this.spliterator(), false).filter(promptFilterMetadata -> promptFilterMetadata.getPromptIndex() == promptIndex).findFirst();
    }

    public static interface PromptFilterMetadata {
        public static PromptFilterMetadata from(final int promptIndex, final Object contentFilterMetadata) {
            return new PromptFilterMetadata(){

                @Override
                public int getPromptIndex() {
                    return promptIndex;
                }

                @Override
                public <T> T getContentFilterMetadata() {
                    return (T)contentFilterMetadata;
                }
            };
        }

        public int getPromptIndex();

        public <T> T getContentFilterMetadata();
    }
}

