/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.Media;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class AbstractMessage
implements Message {
    protected final MessageType messageType;
    protected final String textContent;
    protected final List<Media> mediaData;
    protected final Map<String, Object> properties;

    protected AbstractMessage(MessageType messageType, String content) {
        this(messageType, content, Map.of());
    }

    protected AbstractMessage(MessageType messageType, String content, Map<String, Object> messageProperties) {
        Assert.notNull((Object)((Object)messageType), (String)"Message type must not be null");
        this.messageType = messageType;
        this.textContent = content;
        this.mediaData = new ArrayList<Media>();
        this.properties = messageProperties;
    }

    protected AbstractMessage(MessageType messageType, String textContent, List<Media> mediaData) {
        this(messageType, textContent, mediaData, Map.of());
    }

    protected AbstractMessage(MessageType messageType, String textContent, List<Media> mediaData, Map<String, Object> messageProperties) {
        Assert.notNull((Object)((Object)messageType), (String)"Message type must not be null");
        Assert.notNull((Object)textContent, (String)"Content must not be null");
        Assert.notNull(mediaData, (String)"media data must not be null");
        this.messageType = messageType;
        this.textContent = textContent;
        this.mediaData = new ArrayList<Media>(mediaData);
        this.properties = messageProperties;
    }

    protected AbstractMessage(MessageType messageType, Resource resource) {
        this(messageType, resource, Collections.emptyMap());
    }

    protected AbstractMessage(MessageType messageType, Resource resource, Map<String, Object> messageProperties) {
        Assert.notNull((Object)((Object)messageType), (String)"Message type must not be null");
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        this.messageType = messageType;
        this.properties = messageProperties;
        this.mediaData = new ArrayList<Media>();
        try (InputStream inputStream = resource.getInputStream();){
            this.textContent = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read resource", ex);
        }
    }

    @Override
    public String getContent() {
        return this.textContent;
    }

    @Override
    public List<Media> getMedia() {
        return this.mediaData;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaData == null ? 0 : this.mediaData.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMessage other = (AbstractMessage)obj;
        if (this.mediaData == null ? other.mediaData != null : !this.mediaData.equals(other.mediaData)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.messageType == other.messageType;
    }
}

