/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat;

import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.model.ModelResult;
import org.springframework.lang.Nullable;

public class Generation
implements ModelResult<AssistantMessage> {
    private AssistantMessage assistantMessage;
    private ChatGenerationMetadata chatGenerationMetadata;

    public Generation(String text) {
        this.assistantMessage = new AssistantMessage(text);
    }

    public Generation(String text, Map<String, Object> properties) {
        this.assistantMessage = new AssistantMessage(text, properties);
    }

    @Override
    public AssistantMessage getOutput() {
        return this.assistantMessage;
    }

    @Override
    public ChatGenerationMetadata getMetadata() {
        ChatGenerationMetadata chatGenerationMetadata = this.chatGenerationMetadata;
        return chatGenerationMetadata != null ? chatGenerationMetadata : ChatGenerationMetadata.NULL;
    }

    public Generation withGenerationMetadata(@Nullable ChatGenerationMetadata chatGenerationMetadata) {
        this.chatGenerationMetadata = chatGenerationMetadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Generation)) {
            return false;
        }
        Generation that = (Generation)o;
        return Objects.equals(this.assistantMessage, that.assistantMessage) && Objects.equals(this.chatGenerationMetadata, that.chatGenerationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.assistantMessage, this.chatGenerationMetadata);
    }

    public String toString() {
        return "Generation{assistantMessage=" + String.valueOf(this.assistantMessage) + ", chatGenerationMetadata=" + String.valueOf(this.chatGenerationMetadata) + "}";
    }
}

