/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.chat.Generation;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.model.ModelResponse;
import org.springframework.util.CollectionUtils;

public class ChatResponse
implements ModelResponse<Generation> {
    private final ChatResponseMetadata chatResponseMetadata;
    private final List<Generation> generations;

    public ChatResponse(List<Generation> generations) {
        this(generations, ChatResponseMetadata.NULL);
    }

    public ChatResponse(List<Generation> generations, ChatResponseMetadata chatResponseMetadata) {
        this.chatResponseMetadata = chatResponseMetadata;
        this.generations = List.copyOf(generations);
    }

    @Override
    public List<Generation> getResults() {
        return this.generations;
    }

    @Override
    public Generation getResult() {
        if (CollectionUtils.isEmpty(this.generations)) {
            return null;
        }
        return this.generations.get(0);
    }

    @Override
    public ChatResponseMetadata getMetadata() {
        return this.chatResponseMetadata;
    }

    public String toString() {
        return "ChatResponse [metadata=" + String.valueOf(this.chatResponseMetadata) + ", generations=" + String.valueOf(this.generations) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatResponse)) {
            return false;
        }
        ChatResponse that = (ChatResponse)o;
        return Objects.equals(this.chatResponseMetadata, that.chatResponseMetadata) && Objects.equals(this.generations, that.generations);
    }

    public int hashCode() {
        return Objects.hash(this.chatResponseMetadata, this.generations);
    }
}

