/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.aot;

import java.lang.reflect.Method;
import java.util.Set;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.ChatMessage;
import org.springframework.ai.chat.messages.FunctionMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.model.function.FunctionCallbackWrapper;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class SpringAiCoreRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(@NonNull RuntimeHints hints, @Nullable ClassLoader classLoader) {
        Set<Class> chatTypes = Set.of(AbstractMessage.class, AssistantMessage.class, ChatMessage.class, FunctionMessage.class, Message.class, MessageType.class, UserMessage.class, SystemMessage.class, FunctionCallbackContext.class, FunctionCallback.class, FunctionCallbackWrapper.class);
        for (Class c : chatTypes) {
            hints.reflection().registerType(c, new MemberCategory[0]);
        }
        Method getDescription = ReflectionUtils.findMethod(FunctionCallback.class, (String)"getDescription");
        hints.reflection().registerMethod(getDescription, ExecutableMode.INVOKE);
        Method getInputTypeSchema = ReflectionUtils.findMethod(FunctionCallback.class, (String)"getInputTypeSchema");
        hints.reflection().registerMethod(getInputTypeSchema, ExecutableMode.INVOKE);
        Method getName = ReflectionUtils.findMethod(FunctionCallback.class, (String)"getName");
        hints.reflection().registerMethod(getName, ExecutableMode.INVOKE);
        for (String r : Set.of("antlr4/org/springframework/ai/vectorstore/filter/antlr4/Filters.g4", "embedding/embedding-model-dimensions.properties")) {
            hints.resources().registerResource((Resource)new ClassPathResource(r));
        }
    }
}

