/*
 * Copyright 2023 - 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.ai.model;

/**
 * Interface representing metadata associated with an AI model's response. This interface
 * is designed to provide additional information about the generative response from an AI
 * model, including processing details and model-specific data. It serves as a value
 * object within the core domain, enhancing the understanding and management of AI model
 * responses in various applications.
 *
 * @author Mark Pollack
 * @since 0.8.0
 */
public interface ResponseMetadata {

}
