/*
 * Copyright 2023 - 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.ai.model;

/**
 * Interface representing the customizable options for AI model interactions. This marker
 * interface allows for the specification of various settings and parameters that can
 * influence the behavior and output of AI models. It is designed to provide flexibility
 * and adaptability in different AI scenarios, ensuring that the AI models can be
 * fine-tuned according to specific requirements.
 *
 * @author Mark Pollack
 * @since 0.8.0
 */
public interface ModelOptions {

}
